package easik.sketch;

import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.ClassBasedEdgeFactory;

/**
 * This class is the same as DefaultDirectedGraph but changed to support
 * multiple edges between two nodes
 * 
 * @author Kevin Green 2006
 * @since 2006-08-15 Kevin Green
 * @version 2006-05-23 Kevin Green
 *
 * @param <V> Vector
 * @param <E> Edge
 */
public class DefaultDirectedMultigraph<V, E>
extends AbstractBaseGraph<V, E>
implements DirectedGraph<V, E>
{

//~ Constructors ----------------------------------------------------------

/**
 * Creates a new directed graph.
 *
 * @param edgeClass class on which to base factory for edges
 */
public DefaultDirectedMultigraph(Class<? extends E> edgeClass)
{
    this(new ClassBasedEdgeFactory<V, E>(edgeClass));
}

/**
 * Creates a new directed graph with the specified edge factory.
 *
 * @param ef the edge factory of the new graph.
 */
public DefaultDirectedMultigraph(EdgeFactory<V, E> ef)
{
    super(ef, true, true);
}
}